<?php
session_start();
include "../include/config.php";


// Handle form submission
$error = "";
if ($_SERVER["REQUEST_METHOD"] == "POST") { 
    $user = trim($_POST["username"]);
    $pass = trim($_POST["password"]);

    // Query the database
    $stmt = $conn->prepare("SELECT id, Email, username, password FROM admin_login WHERE username = ?");
    $stmt->bind_param("s", $user);
    $stmt->execute();
    $stmt->store_result(); 
    
    if ($stmt->num_rows > 0) {
        $stmt->bind_result($id, $email, $username, $hashed_password);
        $stmt->fetch();

        // Verify password (Assuming password is hashed in the database)
        if (password_verify($pass, $hashed_password)) {
            $_SESSION["username"] = $username;
            $_SESSION["id"] = $id;
            $_SESSION["email"] = $email;
            header("Location: /PORTAL/index.php"); // Redirect to dashboard
            exit();
        } else {
            $error = "Invalid username or password.";
        }
    } else {
        $error = "User not found.";
    }
    $stmt->close();
}
$conn->close();
?>




<!DOCTYPE html>
<!-- Website - www.codingnepalweb.com -->
<html lang="en" dir="ltr">
  <head>
    <meta charset="utf-8" />
    <title>Animated Login Form | CodingNepal</title>
    <link rel="stylesheet" href="style.css" />
    
      <style>
        body { font-family: Arial, sans-serif; display: flex; justify-content: center; align-items: center; height: 100vh; }
        .login-box { width: 500px; padding: 20px; background: white; box-shadow: 0px 0px 10px 0px #0000001a; border-radius: 5px; text-align: center; }
        .txt_field { margin-bottom: 15px; }
        input { width: 100%; padding: 10px; margin-top: 5px; border: 1px solid #ccc; border-radius: 4px; }
        .error { color: red; margin-bottom: 10px; }
        .btn { background: green; color: white; border: none; padding: 10px; width: 100%; cursor: pointer; }
        .btn:hover { background: darkgreen; }
        .signup_link { margin-top: 10px; }
    </style>
    <style>
    
 body {
    font-family: Arial, sans-serif;
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    background: url('maritime.jpg') no-repeat center center/cover;
    position: relative;
    margin: 0;
}

/* Green overlay */
body::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 128, 0, 0.7); /* Nigerian green with 70% opacity */
    z-index: 0;
}

/* Ensures content stays on top */
.container {
    position: relative;
    z-index: 1;
    background: white;
    padding: 20px;
    border-radius: 8px;
    box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
    text-align: center;
}

        .txt_field {
            position: relative;
            margin: 10px 0;
        }
        input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            outline: none;
        }
        .pass {
            text-align: right;
            font-size: 14px;
            margin: 5px 0;
        }
        .pass a {
            text-decoration: none;
            color: blue;
        }
        .btn {
            background: blue;
            color: white;
            padding: 10px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            width: 100%;
        }
        .signup_link {
            margin-top: 10px;
        }
        .password-wrapper {
            position: relative;
        }
        .password-wrapper input {
            padding-right: 40px; /* Space for eye icon */
        }
        .toggle-password {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            font-size: 18px;
            color: gray;
        }
    </style>
    
  </head>
  <body>
   <div class="login-box">
    <h2>Login</h2>
    <?php if ($error) { echo "<p class='error'>$error</p>"; } ?>
    <div class="container">
    <form method="post">
        <div class="txt_field">
            <input type="text" name="username" required placeholder="Username" />
        </div>
        <div class="txt_field password-wrapper">
            <input type="password" id="password" name="password" required placeholder="Password" />
            <span class="toggle-password" onclick="togglePassword()">👁️</span>
        </div>
        <div class="pass"><a href="#">Forgot Password?</a></div>
        <input type="submit" class="btn" value="Login" />
        <div class="signup_link">Not a member? <a href="#">Signup</a></div>
    </form>
</div>

<script>
    function togglePassword() {
        let passwordField = document.getElementById("password");
        let icon = document.querySelector(".toggle-password");

        if (passwordField.type === "password") {
            passwordField.type = "text";
            icon.textContent = "🙈"; // Change icon to hide mode
        } else {
            passwordField.type = "password";
            icon.textContent = "👁️"; // Change back to eye icon
        }
    }
</script>
</div>
  </body>
</html>
