<?php
include 'include/header.php';



?>
  <!--end::Head-->
  <!--begin::Body-->
  <body class="layout-fixed sidebar-expand-lg bg-body-tertiary">
    <!--begin::App Wrapper-->
    <div class="app-wrapper">
        
        <?php
        include 'include/nav.php';
        
        ?>

      <!--end::Sidebar-->
      <!--begin::App Main-->
      <main class="app-main">
       
       <?php


// Fetch truck data
$sql = "SELECT * FROM `trucks` WHERE status = 1";
$result = $conn->query($sql);
?>


    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <style>
   
        h2 {
            text-align: center;
        }
        .container {
            background: white;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0px 0px 10px rgba(0,0,0,0.1);
        }
        table {
            width: 100%;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5);
            align-items: center;
            justify-content: center;
        }
        .modal-content {
            background: white;
            padding: 20px;
            border-radius: 5px;
            width: 50%;
            text-align: center;
        }
        .close {
            float: right;
            cursor: pointer;
            font-size: 20px;
        }
        .image-container {
            display: flex;
            justify-content: space-around;
            margin-top: 10px;
        }
        .image-container img {
            max-width: 45%;
            height: auto;
            border-radius: 5px;
        }
 
    </style>

    <div class="container">
        <h2>Trucks Management (Approved Trucks)</h2>
        <table id="trucksTable" class="display">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Truck Name</th>
                    <th>Company</th>
                    <th>Registration</th>
                    <th>Chasis</th>
                    <th>Make</th>
                    <th>Model</th>
                    <th>Year</th>
                    <th>Color</th>
                    <th>Capacity</th>
                    <th>Image</th>
                    <th>Status</th>
                    <th>Availability</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $result->fetch_assoc()) { ?>
                    <tr>
                        <td><?php echo $row['id']; ?></td>
                        <td><?php echo $row['TruckName']; ?></td>
                        <td><?php echo $row['Company']; ?></td>
                        <td><?php echo $row['registration_number']; ?></td>
                        <td><?php echo $row['chasis']; ?></td>
                        <td><?php echo $row['make']; ?></td>
                        <td><?php echo $row['model']; ?></td>
                        <td><?php echo $row['year']; ?></td>
                        <td><?php echo $row['color']; ?></td>
                        <td><?php echo $row['capacity']; ?></td>
                        <td><img src="uploads/<?php echo $row['image']; ?>" width="50"></td>
                        <td><?php echo $row['status']; ?></td>
                        <td><?php echo $row['availability']; ?></td>
                        <td>
                            <button onclick="viewDetails(<?php echo htmlspecialchars(json_encode($row)); ?>)">Details</button>
                            <button onclick="toggleStatus(<?php echo $row['id']; ?>, '<?php echo $row['status']; ?>')">
                                <?php echo ($row['status'] == 'enabled') ? 'Disable' : 'Enable'; ?>
                            </button>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
        <br>
        <button onclick="downloadCSV()">Download CSV</button>
    </div>

   <div id="detailsModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal()">&times;</span>
            <h3>Truck Details</h3>
            <p id="truckDetails"></p>
            <div class="image-container">
                <img id="truckImage1">
                <img id="truckImage2">
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $('#trucksTable').DataTable({
                "pageLength": 10,
                "lengthMenu": [[10, 20, 50, 100], [10, 20, 50, 100]],
                "ordering": true,
                "searching": true
            });
        });

function viewDetails(data) {
            document.getElementById('truckDetails').innerHTML = `
                <strong>Truck Name:</strong> ${data.TruckName}<br>
                <strong>Company:</strong> ${data.Company}<br>
                <strong>Registration:</strong> ${data.registration_number}<br>
                <strong>Chasis:</strong> ${data.chasis}<br>
                <strong>Make:</strong> ${data.make}<br>
                <strong>Model:</strong> ${data.model}<br>
                <strong>Year:</strong> ${data.year}<br>
                <strong>Color:</strong> ${data.color}<br>
                <strong>Capacity:</strong> ${data.capacity}<br>
                <strong>Status:</strong> ${data.status}<br>
                <strong>Availability:</strong> ${data.availability}`;
            document.getElementById('truckImage1').src =  data.image;
            document.getElementById('truckImage2').src =  data.image2;
            document.getElementById('detailsModal').style.display = 'flex';
        }


        function closeModal() {
            document.getElementById('detailsModal').style.display = 'none';
        }

        function toggleStatus(id, currentStatus) {
            let newStatus = currentStatus === 'enabled' ? 'disabled' : 'enabled';
            $.post('update_status.php', { truck_id: id, status: newStatus }, function(response) {
                location.reload();
            });
        }

        function downloadCSV() {
            window.location.href = 'download_csv.php';
        }
    </script>

       
       
      </main>
      <!--end::App Main-->
      <!--begin::Footer-->
   

<?php
include 'include/footer.php';



?>