<?php
include 'include/dbconnect.php';


header('Content-Type: application/json');

if (!isset($_POST['start_date']) || !isset($_POST['end_date'])) {
    echo json_encode(["error" => "Invalid request parameters"]);
    exit;
}

$start_date = $_POST['start_date'] . " 00:00:00";
$end_date = $_POST['end_date'] . " 23:59:59";

$query = "SELECT id, user_id, amount, type, Description, PaymentRef, date_time 
          FROM transactions 
          WHERE (type = 'credit' OR type = 'Credit') 
          AND date_time BETWEEN ? AND ?";

if ($stmt = $conn->prepare($query)) {
    $stmt->bind_param("ss", $start_date, $end_date);
    $stmt->execute();
    $result = $stmt->get_result();

    $transactions = [];
    while ($row = $result->fetch_assoc()) {
   $transactions[] = [
    "id" => htmlspecialchars($row['id'] ?? ''),
    "user_id" => htmlspecialchars($row['user_id'] ?? ''),
    "amount" => htmlspecialchars($row['amount'] ?? ''),
    "type" => htmlspecialchars($row['type'] ?? ''),
    "Description" => htmlspecialchars($row['Description'] ?? 'N/A'),
    "PaymentRef" => htmlspecialchars($row['PaymentRef'] ?? 'N/A'),
    "date_time" => htmlspecialchars($row['date_time'] ?? '')
];

    }

    echo json_encode(["data" => $transactions]);
    exit;
} else {
    echo json_encode(["error" => "Failed to prepare statement"]);
    exit;
}
?>
