<?php
include 'include/header.php';
?>

<body class="layout-fixed sidebar-expand-lg bg-body-tertiary">
    <div class="app-wrapper">
        <?php include 'include/nav.php'; ?>

        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
        <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
        <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>

        <div class="container mt-4">
            <h2 class="mb-3 text-center">Transactions - Debits</h2>
            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="start_date">Start Date:</label>
                    <input type="date" id="start_date" class="form-control">
                </div>
                <div class="col-md-4">
                    <label for="end_date">End Date:</label>
                    <input type="date" id="end_date" class="form-control">
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button id="filterBtn" class="btn btn-primary">Filter</button>
                </div>
            </div>

            <table id="transactionsTable" class="table table-striped table-bordered">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>User ID</th>
                        <th>Amount</th>
                        <th>Type</th>
                        <th>Description</th>
                        <th>Payment Ref</th>
                        <th>Date & Time</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                      $query = "SELECT * FROM transactions WHERE type = 'debit' OR type = 'Debit'";
                    $result = mysqli_query($conn, $query);

                    while ($row = mysqli_fetch_assoc($result)) {
                        echo "<tr>";
                    echo "<td>" . htmlspecialchars($row['id'] ?? '') . "</td>";
        echo "<td>" . htmlspecialchars($row['user_id'] ?? '') . "</td>";
        echo "<td>" . htmlspecialchars($row['amount'] ?? '') . "</td>";
        echo "<td>" . htmlspecialchars($row['type'] ?? '') . "</td>";
        echo "<td>" . htmlspecialchars($row['Description'] ?? 'N/A') . "</td>";
        echo "<td>" . htmlspecialchars($row['PaymentRef'] ?? 'N/A') . "</td>";
        echo "<td>" . htmlspecialchars($row['date_time'] ?? '') . "</td>";
                        echo "</tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>

        <script>
            $(document).ready(function() {
                var table = $('#transactionsTable').DataTable({
                    dom: 'Bfrtip',
                    buttons: ['copyHtml5', 'excelHtml5', 'csvHtml5', 'pdfHtml5', 'print'],
                    paging: true,
                    searching: true,
                    ordering: true,
                    responsive: true,
                    lengthMenu: [10, 25, 50, 100],
                    columns: [
                        { data: "id" },
                        { data: "user_id" },
                        { data: "amount" },
                        { data: "type" },
                        { data: "Description" },
                        { data: "PaymentRef" },
                        { data: "date_time" }
                    ]
                });

                $('#filterBtn').click(function() {
                    var startDate = $('#start_date').val();
                    var endDate = $('#end_date').val();

                    if (startDate !== "" && endDate !== "") {
                        $.ajax({
                            url: 'filter_transactionsdebit.php',
                            method: 'POST',
                            data: { start_date: startDate, end_date: endDate },
                            dataType: 'json',
                            success: function(response) {
                                if (response.data) {
                                    table.clear().draw();
                                    table.rows.add(response.data).draw();
                                } else {
                                    alert("No transactions found for the selected date range.");
                                }
                            },
                            error: function(xhr, status, error) {
                                console.error("AJAX Error:", error);
                            }
                        });
                    }
                });
            });
        </script>
    </div>
</body>

<?php include 'include/footer.php'; ?>
