<?php
include 'include/header.php';



?>
  <!--end::Head-->
  <!--begin::Body-->
  <body class="layout-fixed sidebar-expand-lg bg-body-tertiary">
    <!--begin::App Wrapper-->
    <div class="app-wrapper">
        
        <?php
        include 'include/nav.php';
        
        ?>

      <!--end::Sidebar-->
      <!--begin::App Main-->
      <main class="app-main">
       
       <?php

// Fetch records from the database
$sql = "SELECT * FROM regcoy WHERE regtype = 'Trucker'";
$result = $conn->query($sql);
?>

    
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- DataTables Scripts -->
    <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>

    <style>
     
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: left;
        }
        .action-btn {
            padding: 5px 10px;
            border: none;
            cursor: pointer;
            font-size: 14px;
            border-radius: 4px;
        }
        .view-btn {
            background-color: #007bff;
            color: white;
        }
        .enable-btn {
            background-color: #28a745;
            color: white;
        }
        .disable-btn {
            background-color: #dc3545;
            color: white;
        }
        .status-active {
            color: green;
            font-weight: bold;
        }
        .status-inactive {
            color: red;
            font-weight: bold;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 10;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            justify-content: center;
            align-items: center;
        }
        .modal-content {
            background-color: white;
            padding: 20px;
            width: 600px;
            border-radius: 10px;
            position: relative;
            text-align: left;
        }
        .modal img {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            display: block;
            margin: 0 auto;
        }
        .modal h3 {
            text-align: center;
            margin-top: 10px;
        }
        .modal .details {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
        }
        .modal .details p {
            width: 48%;
            margin: 5px 0;
        }
        .close-btn {
            position: absolute;
            top: 10px;
            right: 15px;
            font-size: 20px;
            cursor: pointer;
        }
    </style>


    <h2>Registered Truckers</h2>
    <table id="recordsTable" class="display nowrap" style="width:100%">
        <thead>
            <tr>
                <th>ID</th>
                <th>Company Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Sector</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($row = $result->fetch_assoc()) { ?>
                <tr>
                    <td><?= $row['id'] ?></td>
                    <td><?= $row['coyname'] ?></td>
                    <td><?= $row['coyemail'] ?></td>
                    <td><?= $row['coyphoneno'] ?></td>
                    <td><?= $row['sector'] ?></td>
                    <td class="<?= $row['status'] == 1 ? 'status-active' : 'status-inactive' ?>">
                        <?= $row['status'] == 1 ? 'Active' : 'Inactive' ?>
                    </td>
                    <td>
                        <button class="action-btn view-btn" onclick="viewDetails(<?= htmlspecialchars(json_encode($row)) ?>)">View</button>
                        <button class="action-btn enable-btn" onclick="updateStatus(<?= $row['id'] ?>, 1)">Enable</button>
                        <button class="action-btn disable-btn" onclick="updateStatus(<?= $row['id'] ?>, 0)">Disable</button>
                    </td>
                </tr>
            <?php } ?>
        </tbody>
    </table>

    <!-- Modal for View Details -->
    <div id="detailsModal" class="modal">
        <div class="modal-content">
            <span class="close-btn" onclick="closeModal()">&times;</span>
            <img id="profileImage" src="" alt="Company Logo">
            <h3 id="modalTitle"></h3>
            <div class="details">
                <p><strong>Email:</strong> <span id="modalEmail"></span></p>
                <p><strong>Phone:</strong> <span id="modalPhone"></span></p>
                <p><strong>Sector:</strong> <span id="modalSector"></span></p>
                <p><strong>Status:</strong> <span id="modalStatus"></span></p>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $('#recordsTable').DataTable({
                pageLength: 10,
                lengthMenu: [[10, 20, 50, 100], [10, 20, 50, 100]],
                scrollX: true,
                scrollY: '50vh',
                dom: 'Bfrtip',
                buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
            });
        });

        function viewDetails(data) {
            $("#profileImage").attr("src", data.logo ? data.logo : "default.png");
            $("#modalTitle").text(data.coyname);
            $("#modalEmail").text(data.coyemail);
            $("#modalPhone").text(data.coyphoneno);
            $("#modalSector").text(data.sector);
            $("#modalStatus").text(data.status == 1 ? 'Active' : 'Inactive').css("color", data.status == 1 ? "green" : "red");
            $("#detailsModal").css("display", "flex");
        }

        function closeModal() {
            $("#detailsModal").css("display", "none");
        }

        function updateStatus(id, status) {
            if (confirm("Are you sure you want to change the status?")) {
                $.post("update_status.php", { id: id, status: status }, function(response) {
                    alert(response);
                    location.reload();
                });
            }
        }
    </script>



       
       
      </main>
      <!--end::App Main-->
      <!--begin::Footer-->
   

<?php
include 'include/footer.php';



?>