<?php
include 'include/dbconnect.php';

if (isset($_POST['id'])) {
    $id = intval($_POST['id']);
    $sql = "SELECT * FROM containerdetails WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $container = $result->fetch_assoc();
    
    if ($container) {
        echo "<div class='text-center'><img src='" . $container['Image1'] . "' alt='Container Image' class='img-fluid mb-3' style='max-width: 200px;'></div>";
        echo "<h5>Container No: " . $container['containerno'] . "</h5>";
        echo "<p><strong>Shipliner:</strong> " . $container['shipliner'] . "</p>";
        echo "<p><strong>Manufacture Year:</strong> " . $container['manufactureyear'] . "</p>";
        echo "<p><strong>Container Type:</strong> " . $container['containertype'] . "</p>";
        echo "<p><strong>Delivery Location:</strong> " . $container['Deliverylocation'] . "</p>";
    } else {
        echo "<p class='text-danger'>Container not found!</p>";
    }
}
?>
