<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header('Content-Type: application/json');

include 'include/dbconnect.php';

// DataTables Request Parameters
$draw = isset($_POST['draw']) ? intval($_POST['draw']) : 1;
$start = isset($_POST['start']) ? intval($_POST['start']) : 0;
$length = isset($_POST['length']) ? intval($_POST['length']) : 10;
$searchValue = isset($_POST['search']['value']) ? $_POST['search']['value'] : '';

// Get Total Records
$totalRecordsQuery = "SELECT COUNT(*) AS count FROM containerdetails";
$totalRecordsResult = $conn->query($totalRecordsQuery);
$totalRecords = $totalRecordsResult->fetch_assoc()['count'];

// Apply Search Filter
$where = "";
if (!empty($searchValue)) {
    $where = " WHERE containerno LIKE '%$searchValue%' OR shipliner LIKE '%$searchValue%'";
}

// Get Total Filtered Records
$totalFilteredQuery = "SELECT COUNT(*) AS count FROM containerdetails $where";
$totalFilteredResult = $conn->query($totalFilteredQuery);
$totalFiltered = $totalFilteredResult->fetch_assoc()['count'];

// Fetch Data with Limit
$sql = "SELECT id, shipliner, containerno, manufactureyear, containertype, Deliverylocation, status FROM containerdetails $where ORDER BY id DESC LIMIT $start, $length";
$result = $conn->query($sql);

$data = [];
while ($row = $result->fetch_assoc()) {
    $row['status'] = ($row['status'] == 1) ? '<span class="text-success fw-bold">Active</span>' : '<span class="text-danger fw-bold">Inactive</span>';
    $row['action'] = '<button class="btn btn-primary viewDetails" data-id="' . $row['id'] . '" data-bs-toggle="modal" data-bs-target="#detailsModal">View Details</button>';
    $data[] = $row;
}

// Return JSON Response
echo json_encode([
    "draw" => $draw,
    "recordsTotal" => $totalRecords,
    "recordsFiltered" => $totalFiltered,
    "data" => $data
]);

$conn->close();
?>
