<?php
include 'include/header.php';



?>
  <!--end::Head-->
  <!--begin::Body-->
  <body class="layout-fixed sidebar-expand-lg bg-body-tertiary">
    <!--begin::App Wrapper-->
    <div class="app-wrapper">
        
        <?php
        include 'include/nav.php';
        
        ?>

      <!--end::Sidebar-->
      <!--begin::App Main-->
      <main class="app-main">
       
       <?php

// Fetch Container Details
$sql = "SELECT * FROM containerdetails ORDER BY id DESC";
$result = $conn->query($sql);
?>



    <!-- CSS Libraries -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
    
    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>

    <style>
        /* Table Styling */
        .dataTables_wrapper {
            width: 100%;
            overflow-x: auto;
        }

        /* Standardized Modal Styling */
        .modal-dialog {
            max-width: 50%;
            margin: auto;
        }
        .modal-content {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0px 10px 30px rgba(0, 0, 0, 0.1);
        }
        .modal-header {
            background: #007bff;
            color: #fff;
            border-top-left-radius: 12px;
            border-top-right-radius: 12px;
        }
        .modal-body {
            padding: 20px;
        }
        .modal-footer {
            border-top: none;
            padding-bottom: 20px;
        }
        .details-table th {
            text-align: left;
            padding: 8px;
            width: 40%;
            background: #f8f9fa;
        }
        .details-table td {
            padding: 8px;
        }
    </style>

    <div class="container mt-4">
        <h2 class="text-center">Container Details</h2>
        <button id="downloadCSV" class="btn btn-success mb-3">Download CSV</button>
        <table id="containerTable" class="display table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>S/N</th>
                    <th>Shipliner</th>
                    <th>Container No</th>
                    <th>Import Type</th>
                    <th>Container Type</th>
                    <th>Delivery Location</th>
                    <th>Cargo Description</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $sn = 1; ?>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $sn++ ?></td>
                        <td><?= $row['shipliner'] ?></td>
                        <td><?= $row['containerno'] ?></td>
                        <td><?= $row['ImportType'] ?></td>
                        <td><?= $row['containertype'] ?></td>
                        <td><?= $row['Deliverylocation'] ?></td>
                         <td><?= $row['Cargodescription'] ?></td>
                        <td>
                            <button class="btn btn-primary viewDetails"
                                    data-bs-toggle="modal" data-bs-target="#detailsModal"
                                    data-shipliner="<?= $row['shipliner'] ?>"
                                    data-containerno="<?= $row['containerno'] ?>"
                                    data-manufactureyear="<?= $row['manufactureyear'] ?>"
                                    data-containertype="<?= $row['containertype'] ?>"
                                    data-deliverylocation="<?= $row['Deliverylocation'] ?>"
                                    data-status="<?= $row['status'] ?>">
                                View Details
                            </button>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="detailsModal" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalLabel">Container Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <table class="table table-bordered details-table">
                        <tr><th>Shipliner</th><td id="detail-shipliner"></td></tr>
                        <tr><th>Container No</th><td id="detail-containerno"></td></tr>
                        <tr><th>Manufacture Year</th><td id="detail-manufactureyear"></td></tr>
                        <tr><th>Container Type</th><td id="detail-containertype"></td></tr>
                        <tr><th>Delivery Location</th><td id="detail-deliverylocation"></td></tr>
                        <tr><th>Status</th><td id="detail-status"></td></tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            // Initialize DataTables
            $('#containerTable').DataTable();

            // View Details Modal
            $(document).on('click', '.viewDetails', function() {
                $('#detail-shipliner').text($(this).data('shipliner'));
                $('#detail-containerno').text($(this).data('containerno'));
                $('#detail-manufactureyear').text($(this).data('manufactureyear'));
                $('#detail-containertype').text($(this).data('containertype'));
                $('#detail-deliverylocation').text($(this).data('deliverylocation'));

                var statusText = ($(this).data('status') == 1) ? '<span class="text-success fw-bold">Active</span>' : '<span class="text-danger fw-bold">Inactive</span>';
                $('#detail-status').html(statusText);

                // Open the modal
                $('#detailsModal').modal('show');
            });

            // Download CSV Functionality
            $('#downloadCSV').click(function() {
                var csv = 'S/N,Shipliner,Container No,Manufacture Year,Container Type,Delivery Location,Status\n';
                var rows = $('#containerTable').DataTable().rows().data();

                rows.each(function(row, index) {
                    var statusText = row[6].includes('Active') ? 'Active' : 'Inactive';
                    csv += (index + 1) + ',' + row[1] + ',' + row[2] + ',' + row[3] + ',' + row[4] + ',' + row[5] + ',' + statusText + '\n';
                });

                var blob = new Blob([csv], { type: 'text/csv' });
                var link = document.createElement('a');
                link.href = URL.createObjectURL(blob);
                link.download = 'container_details.csv';
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
            });
        });
    </script>

       
       
      </main>
      <!--end::App Main-->
      <!--begin::Footer-->
   

<?php
include 'include/footer.php';



?>