<?php
include 'include/header.php';



?>
  <!--end::Head-->
  <!--begin::Body-->
  <body class="layout-fixed sidebar-expand-lg bg-body-tertiary">
    <!--begin::App Wrapper-->
    <div class="app-wrapper">
        
        <?php
        include 'include/nav.php';
        
        ?>

      <!--end::Sidebar-->
      <!--begin::App Main-->
      <main class="app-main">
       

    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css" />

    <div class="container mt-4">
        <h2>Ticket Resolution</h2>
        <table id="ticketsTable" class="table table-striped">
            <thead>
                <tr>
                    <th>Ticket ID</th>
                    <th>Date Created</th>
                    <th>Issue Type</th>
                    <th>Company</th>
                    <th>Email</th>
                    <th>Status</th>
                    <th>Priority</th>
                    <th>Action</th>
                </tr>
            </thead>
        <tbody>
                <?php
                $query = "SELECT * FROM Ticket_Resolutions WHERE status = 'Resolved' OR status = 'Closed'";
                $result = mysqli_query($conn, $query);
                while ($row = mysqli_fetch_assoc($result)) {
                    echo "<tr>";
                    echo "<td>" . $row['Ticket_ID'] . "</td>";
                    echo "<td>" . $row['Date_Created'] . "</td>";
                    echo "<td>" . $row['Issue_Type'] . "</td>";
                    echo "<td>" . $row['Coyname'] . "</td>";
                    echo "<td>" . $row['Customer_Email'] . "</td>";
                    echo "<td>" . $row['Status'] . "</td>";
                    echo "<td>" . $row['Priority'] . "</td>";
                    echo "<td><button class='btn btn-primary view-details' data-bs-toggle='modal' data-bs-target='#ticketModal' data-ticket='" . htmlspecialchars(json_encode($row), ENT_QUOTES, 'UTF-8') . "'>View Details</button></td>";
                    echo "</tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
<div class="modal fade" id="ticketModal" tabindex="-1" aria-labelledby="ticketModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="ticketModalLabel">Ticket Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="ticketDetails"></div>
                
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $('#ticketsTable').DataTable();
        });
        
        $(document).on("click", ".view-details", function() {
            let ticket = JSON.parse($(this).attr("data-ticket"));
            
            let details = `
                <strong>Ticket ID:</strong> <span>${ticket.Ticket_ID}</span><br>
                <strong>Date Created:</strong> ${ticket.Date_Created}<br>
                <strong>Issue Type:</strong> ${ticket.Issue_Type}<br>
                <strong>Reference:</strong> ${ticket.Reference}<br>
                <strong>Message:</strong> ${ticket.Message}<br>
                <strong>Company:</strong> ${ticket.Coyname}<br>
                <strong>Email:</strong> ${ticket.Customer_Email}<br>
                <strong>Status:</strong> ${ticket.Status}<br>
                <strong>Priority:</strong> ${ticket.Priority}<br>
                <strong>Resolution Notes:</strong> ${ticket.Resolution_Notes}<br>
                <strong>Date Resolved:</strong> ${ticket.Date_Resolved}<br>
            `;
            
            $("#ticketDetails").html(details);
            $("#updateStatus").val(ticket.Status);
            $("#ticketId").val(ticket.Ticket_ID);
        });
        
        $("#updateTicket").on("click", function() {
            let ticketID = $("#ticketId").val();
            let newStatus = $("#updateStatus").val();
            
            if (!ticketID) {
                alert("Error: Ticket ID is missing!");
                return;
            }
            
            $.post("update_ticket.php", { Ticket_ID: ticketID, Status: newStatus }, function(response) {
                alert(response);
                location.reload();
            }).fail(function(jqXHR, textStatus, errorThrown) {
                alert("Error: " + textStatus + " - " + errorThrown);
            });
        });
    </script>

       
       
      </main>
      <!--end::App Main-->
      <!--begin::Footer-->
   

<?php
include 'include/footer.php';



?>